/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.projects.wizards;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.projects.templates.IProjectTemplate;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.projects.ProjectsPlugin;
import com.aptana.projects.internal.wizards.Messages;
import com.aptana.projects.templates.IDefaultProjectTemplate;
import com.aptana.projects.templates.ProjectTemplatesManager;
import com.aptana.projects.wizards.IStepIndicatorWizardPage;
import com.aptana.ui.util.SWTUtils;
import com.aptana.ui.util.UIUtils;
import com.aptana.ui.widgets.StepIndicatorComposite;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.RowDataFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectTemplateSelectionPage
extends WizardPage
implements IStepIndicatorWizardPage {
    private static final int TEMPLATES_COMPOSITE_WIDTH = 450;
    public static final String COMMAND_PROJECT_FROM_TEMPLATE_PROJECT_TEMPLATE_NAME = "projectTemplateId";
    public static final String COMMAND_PROJECT_FROM_TEMPLATE_NEW_WIZARD_ID = "newWizardId";
    private static final int IMAGE_SIZE = 48;
    private TableViewer tagsListViewer;
    private Composite templatesListComposite;
    private Label previewImage;
    private Label previewLabel;
    private Label previewDescription;
    private IProjectTemplate[] fTemplates;
    private IProjectTemplate fSelectedTemplate;
    private static ImageDescriptor wizardDesc = ProjectsPlugin.getImageDescriptor("/icons/project_template_blank.png");
    private Image defaultTemplateImage = null;
    private Map<IProjectTemplate, Image> templateImages;
    private Map<Composite, IProjectTemplate> templateControlMap;
    private Map<String, List<IProjectTemplate>> templateTagsMap;
    protected StepIndicatorComposite stepIndicatorComposite;
    protected String[] stepNames;
    private Composite templatesDescriptionComp;
    private ISelectionChangedListener tagSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = ProjectTemplateSelectionPage.this.tagsListViewer.getSelection();
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                String tag = (String)((IStructuredSelection)selection).getFirstElement();
                ProjectTemplateSelectionPage.this.setSelectedTemplate(tag, (IProjectTemplate)((List)ProjectTemplateSelectionPage.this.templateTagsMap.get(tag)).get(0));
            }
        }
    };

    public ProjectTemplateSelectionPage(String pageName, List<IProjectTemplate> templates) {
        super(pageName);
        if (templates == null) {
            this.fTemplates = new IProjectTemplate[0];
        } else {
            ArrayList<IProjectTemplate> modifiableTemplates = new ArrayList<IProjectTemplate>(templates);
            Collections.sort(modifiableTemplates, new Comparator<IProjectTemplate>(){

                @Override
                public int compare(IProjectTemplate o1, IProjectTemplate o2) {
                    int result = o1.getPriority() - o2.getPriority();
                    return result == 0 ? o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName()) : result;
                }
            });
            this.fTemplates = templates.toArray(new IProjectTemplate[templates.size()]);
        }
        this.setTitle(Messages.ProjectTemplateSelectionPage_Title);
        this.setDescription(Messages.ProjectTemplateSelectionPage_Description);
        this.templateImages = new HashMap<IProjectTemplate, Image>();
        this.templateControlMap = new LinkedHashMap<Composite, IProjectTemplate>();
        this.templateTagsMap = new HashMap<String, List<IProjectTemplate>>();
        this.populateTagsMap();
    }

    public IProjectTemplate getSelectedTemplate() {
        return this.fSelectedTemplate;
    }

    public void createControl(Composite parent) {
        this.defaultTemplateImage = wizardDesc.createImage();
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ProjectTemplateSelectionPage.this.defaultTemplateImage != null) {
                    ProjectTemplateSelectionPage.this.defaultTemplateImage.dispose();
                    ProjectTemplateSelectionPage.this.defaultTemplateImage = null;
                }
                if (ProjectTemplateSelectionPage.this.templateImages != null) {
                    for (Image image : ProjectTemplateSelectionPage.this.templateImages.values()) {
                        if (image == null || image.isDisposed()) continue;
                        image.dispose();
                    }
                }
                ProjectTemplateSelectionPage.this.templateImages = null;
            }
        });
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 10).create());
        main.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.stepIndicatorComposite = new StepIndicatorComposite(main, this.stepNames);
        this.stepIndicatorComposite.setSelection(this.getStepName());
        Label label = new Label(main, 0);
        label.setText(Messages.ProjectTemplateSelectionPage_AvailableTemplates_TXT);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        Composite templateList = this.createTemplatesList(main);
        templateList.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        if (!ArrayUtil.isEmpty((Object[])this.fTemplates)) {
            TableItem[] items;
            boolean foundDefault = false;
            TableItem[] tableItemArray = items = this.tagsListViewer.getTable().getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                String tag = item.getText();
                List<IProjectTemplate> templates = this.templateTagsMap.get(tag);
                for (IProjectTemplate template : templates) {
                    if (!(template instanceof IDefaultProjectTemplate) && (StringUtil.isEmpty((String)template.getDisplayName()) || !template.getDisplayName().contains("Default"))) continue;
                    foundDefault = true;
                    this.setSelectedTemplate(tag, template);
                    break;
                }
                if (foundDefault) break;
                ++n2;
            }
            if (!foundDefault) {
                String tag = items[0].getText();
                this.setSelectedTemplate(tag, this.templateTagsMap.get(tag).get(0));
            }
        }
        KeyListener keyListener = new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000004) {
                    ProjectTemplateSelectionPage.this.setSelectedTemplate(ProjectTemplateSelectionPage.this.getNextTemplate(ProjectTemplateSelectionPage.this.fSelectedTemplate));
                } else if (e.keyCode == 0x1000003) {
                    ProjectTemplateSelectionPage.this.setSelectedTemplate(ProjectTemplateSelectionPage.this.getPreviousTemplate(ProjectTemplateSelectionPage.this.fSelectedTemplate));
                }
            }
        };
        this.templatesListComposite.addKeyListener(keyListener);
        this.tagsListViewer.getTable().addKeyListener(keyListener);
        this.tagsListViewer.getTable().setFocus();
        Dialog.applyDialogFont((Control)main);
        this.setControl((Control)main);
    }

    private int getTemplateIndex(IProjectTemplate template) {
        Control[] children = this.templatesListComposite.getChildren();
        for (Map.Entry<Composite, IProjectTemplate> entry : this.templateControlMap.entrySet()) {
            if (!entry.getValue().equals(template)) continue;
            Composite comp = entry.getKey();
            int i = 0;
            while (i < children.length) {
                if (comp == children[i]) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    protected IProjectTemplate getPreviousTemplate(IProjectTemplate selectedTemplate) {
        int index = this.getTemplateIndex(selectedTemplate);
        if (index == -1) {
            return selectedTemplate;
        }
        Control[] children = this.templatesListComposite.getChildren();
        int prevIndex = index - 1;
        if (prevIndex < 0) {
            prevIndex = children.length - 1;
        }
        return this.templateControlMap.get(children[prevIndex]);
    }

    protected IProjectTemplate getNextTemplate(IProjectTemplate selectedTemplate) {
        int index = this.getTemplateIndex(selectedTemplate);
        if (index == -1) {
            return selectedTemplate;
        }
        int nextIndex = index + 1;
        Control[] children = this.templatesListComposite.getChildren();
        if (nextIndex >= children.length) {
            nextIndex = 0;
        }
        return this.templateControlMap.get(children[nextIndex]);
    }

    private Composite createTemplatesList(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).numColumns(2).create());
        Color background = main.getDisplay().getSystemColor(1);
        main.setBackground(background);
        Composite templateTags = new Composite(main, 2048);
        templateTags.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        boolean exclude = this.templateTagsMap.size() <= 1;
        templateTags.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).hint(150, -1).exclude(exclude).create());
        templateTags.setBackground(background);
        ArrayList<String> tags = new ArrayList<String>(this.templateTagsMap.keySet());
        Collections.sort(tags);
        this.tagsListViewer = new TableViewer(templateTags, 65540);
        this.tagsListViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tagsListViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof String) {
                    return ProjectTemplateSelectionPage.this.getProjectTemplatesManager().getImageForTag((String)element);
                }
                return super.getImage(element);
            }
        });
        this.tagsListViewer.setInput(tags);
        this.tagsListViewer.setComparator(new ViewerComparator(){

            public int category(Object element) {
                return ProjectTemplatesManager.TAG_OTHERS.equals(element) ? 1 : 0;
            }
        });
        Table tagsList = this.tagsListViewer.getTable();
        tagsList.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        tagsList.setBackground(background);
        FontData[] fontData = SWTUtils.resizeFont((Font)tagsList.getFont(), (int)2);
        final Font tagFont = new Font((Device)tagsList.getDisplay(), fontData);
        tagsList.setFont(tagFont);
        tagsList.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                tagFont.dispose();
            }
        });
        this.tagsListViewer.addSelectionChangedListener(this.tagSelectionChangedListener);
        Composite rightComp = new Composite(main, 2048);
        rightComp.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        rightComp.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        rightComp.setBackground(background);
        this.templatesListComposite = new Composite(rightComp, 0);
        this.templatesListComposite.setLayout((Layout)RowLayoutFactory.swtDefaults().extendedMargins(5, 5, 5, 5).spacing(10).fill(true).create());
        this.templatesListComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(450, 250).create());
        this.templatesListComposite.setBackground(background);
        Label separator = new Label(rightComp, 258);
        separator.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Composite descriptionComp = this.createTemplateDescription(rightComp);
        descriptionComp.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).hint(-1, 110).create());
        return main;
    }

    protected Composite createTemplateDescription(Composite parent) {
        FontData[] fontData;
        ScrolledComposite scrolledComp = new ScrolledComposite(parent, 512);
        scrolledComp.setLayout((Layout)new FillLayout());
        this.templatesDescriptionComp = new Composite((Composite)scrolledComp, 0);
        this.templatesDescriptionComp.setLayout((Layout)GridLayoutFactory.swtDefaults().extendedMargins(7, 0, 0, 0).numColumns(2).create());
        scrolledComp.setContent((Control)this.templatesDescriptionComp);
        Color background = this.templatesDescriptionComp.getDisplay().getSystemColor(1);
        scrolledComp.setBackground(background);
        this.templatesDescriptionComp.setBackground(background);
        this.previewImage = new Label(this.templatesDescriptionComp, 0x1000000);
        this.previewImage.setBackground(background);
        this.previewImage.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).create());
        this.previewLabel = new Label(this.templatesDescriptionComp, 16384);
        this.previewLabel.setBackground(background);
        this.previewLabel.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
        FontData[] fontDataArray = fontData = SWTUtils.resizeFont((Font)this.previewLabel.getFont(), (int)2);
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            data.setStyle(data.getStyle() | 1);
            ++n2;
        }
        final Font previewFont = new Font((Device)this.previewLabel.getDisplay(), fontData);
        this.previewLabel.setFont(previewFont);
        this.previewLabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                previewFont.dispose();
            }
        });
        this.previewDescription = new Label(this.templatesDescriptionComp, 64);
        this.previewDescription.setBackground(background);
        this.previewDescription.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).span(2, 1).create());
        this.templatesDescriptionComp.setSize(this.templatesDescriptionComp.computeSize(450, -1));
        return scrolledComp;
    }

    private void setSelectedTag(String tag) {
        this.tagsListViewer.removeSelectionChangedListener(this.tagSelectionChangedListener);
        this.tagsListViewer.setSelection((ISelection)new StructuredSelection((Object)tag));
        this.tagsListViewer.addSelectionChangedListener(this.tagSelectionChangedListener);
        Control[] children = this.templatesListComposite.getChildren();
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control templateControl = controlArray[n2];
            templateControl.dispose();
            ++n2;
        }
        this.templateControlMap.clear();
        List<IProjectTemplate> templates = this.templateTagsMap.get(tag);
        Color background = this.templatesListComposite.getBackground();
        for (IProjectTemplate template : templates) {
            final Composite templateControl = new Composite(this.templatesListComposite, 0);
            templateControl.setLayout((Layout)GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 5, 5).create());
            templateControl.setLayoutData((Object)RowDataFactory.swtDefaults().hint(95, -1).create());
            templateControl.setBackground(background);
            Label image = new Label(templateControl, 0x1000000);
            image.setImage(this.defaultTemplateImage);
            this.templateImages.put(template, this.defaultTemplateImage);
            this.loadImageInBackground(image, template);
            image.setBackground(background);
            image.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).create());
            Label text = new Label(templateControl, 0x1000040);
            text.setText(template.getDisplayName());
            text.setBackground(background);
            text.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).align(0x1000000, 1).create());
            MouseAdapter mouseAdapter = new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    ProjectTemplateSelectionPage.this.setSelectedTemplate((IProjectTemplate)ProjectTemplateSelectionPage.this.templateControlMap.get(templateControl));
                }

                public void mouseDoubleClick(MouseEvent e) {
                    if (ProjectTemplateSelectionPage.this.canFlipToNextPage()) {
                        ProjectTemplateSelectionPage.this.getContainer().showPage(ProjectTemplateSelectionPage.this.getNextPage());
                    }
                }
            };
            templateControl.addMouseListener((MouseListener)mouseAdapter);
            image.addMouseListener((MouseListener)mouseAdapter);
            text.addMouseListener((MouseListener)mouseAdapter);
            this.templateControlMap.put(templateControl, template);
        }
        this.templatesListComposite.layout(true, true);
    }

    private void loadImageInBackground(final Label label, final IProjectTemplate template) {
        final URL iconPath = template.getIconURL();
        if (iconPath != null) {
            final ImageData[] imageData = new ImageData[1];
            Job loadImageJob = new Job("Loading template image..."){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)iconPath);
                        imageData[0] = descriptor.getImageData();
                    }
                    catch (Exception e) {
                        IdeLog.logWarning((Plugin)ProjectsPlugin.getDefault(), (String)("Failed to retrieve the template's image: " + e));
                    }
                    return Status.OK_STATUS;
                }
            };
            EclipseUtil.setSystemForJob((Job)loadImageJob);
            loadImageJob.schedule();
            loadImageJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (imageData[0] != null) {
                        UIUtils.getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                Image image = new Image((Device)UIUtils.getDisplay(), imageData[0]);
                                if (image != null) {
                                    ImageData scaledImageData = image.getImageData();
                                    if (scaledImageData.x != 48 || scaledImageData.y != 48) {
                                        image.dispose();
                                        scaledImageData = scaledImageData.scaledTo(48, 48);
                                        image = ImageDescriptor.createFromImageData((ImageData)scaledImageData).createImage();
                                    }
                                }
                                label.setImage(image);
                                ProjectTemplateSelectionPage.this.templateImages.put(template, image);
                            }
                        });
                    }
                }
            });
        }
    }

    private void setSelectedTemplate(IProjectTemplate template) {
        Set<Composite> templateControls = this.templateControlMap.keySet();
        for (Composite composite : templateControls) {
            Control[] children;
            Color background = this.templateControlMap.get(composite) == template ? composite.getDisplay().getSystemColor(26) : composite.getDisplay().getSystemColor(1);
            composite.setBackground(background);
            Control[] controlArray = children = composite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control childComp = controlArray[n2];
                childComp.setBackground(background);
                ++n2;
            }
        }
        this.previewImage.setImage(this.getImage(template));
        this.previewLabel.setText(template.getDisplayName());
        String text = template == null ? null : template.getDescription();
        this.previewDescription.setText(text == null ? "" : text);
        this.fSelectedTemplate = template;
        this.templatesDescriptionComp.layout();
        this.templatesDescriptionComp.setSize(this.templatesDescriptionComp.computeSize(450, -1));
    }

    private void setSelectedTemplate(String tag, IProjectTemplate template) {
        this.setSelectedTag(tag);
        this.setSelectedTemplate(template);
    }

    private Image getImage(IProjectTemplate template) {
        Image image = this.templateImages.get(template);
        if (image == null) {
            image = this.defaultTemplateImage;
        }
        return image;
    }

    private void populateTagsMap() {
        this.templateTagsMap.clear();
        ArrayList<IProjectTemplate> others = new ArrayList<IProjectTemplate>();
        IProjectTemplate[] iProjectTemplateArray = this.fTemplates;
        int n = this.fTemplates.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectTemplate template = iProjectTemplateArray[n2];
            List tags = template.getTags();
            if (!CollectionsUtil.isEmpty((Collection)tags)) {
                for (String tag : tags) {
                    List<IProjectTemplate> tagTemplates = this.templateTagsMap.get(tag);
                    if (tagTemplates == null) {
                        tagTemplates = new ArrayList<IProjectTemplate>();
                        this.templateTagsMap.put(tag, tagTemplates);
                    }
                    tagTemplates.add(template);
                }
            } else {
                others.add(template);
            }
            ++n2;
        }
        if (!others.isEmpty()) {
            this.templateTagsMap.put(ProjectTemplatesManager.TAG_OTHERS, others);
        }
    }

    @Override
    public void initStepIndicator(String[] stepNames) {
        this.stepNames = stepNames;
    }

    @Override
    public String getStepName() {
        return this.getTitle();
    }

    protected ProjectTemplatesManager getProjectTemplatesManager() {
        return ProjectsPlugin.getDefault().getTemplatesManager();
    }
}

